// Subir DOCX y evaluar
const uploadForm = document.getElementById('uploadForm');
if (uploadForm) {
  uploadForm.addEventListener('submit', async (e) => {
    e.preventDefault();
    const resBox = document.getElementById('uploadResult');
    resBox.textContent = 'Procesando...';
    const fd = new FormData(uploadForm);
    try {
      const r = await fetch('/upload-doc', { method: 'POST', body: fd });
      const data = await r.json();
      if (!data.ok) throw new Error(data.error || 'Error desconocido');
      resBox.innerHTML = `
        <div>✅ Evaluación lista.</div>
        <div class="mt-2 text-sm">
          <div><strong>Score:</strong> ${data.evaluation.score}%</div>
          <div class="mt-1"><strong>Razones:</strong><br>- ${data.evaluation.reasons.join('<br>- ')}</div>
          <div class="mt-1"><strong>Recomendaciones:</strong><br>- ${data.evaluation.recommendations.join('<br>- ')}</div>
        </div>
        <div class="mt-2 text-xs opacity-75">Se agregó al historial del chat.</div>
      `;
      // Refrescar visual del chat sin recargar: usuario ve el mensaje del sistema la próxima vez que entre
    } catch (err) {
      resBox.textContent = '❌ ' + err.message;
    }
  });
}

// Enviar mensaje al chat
const chatForm = document.getElementById('chatForm');
const chatInput = document.getElementById('chatInput');
const chatBox = document.getElementById('chatBox');

function appendBubble(role, text) {
  const wrap = document.createElement('div');
  wrap.className = role === 'user' ? 'text-right' : 'text-left';
  const bubble = document.createElement('div');
  bubble.className = role === 'user'
    ? 'bg-teal-600 text-slate-900 inline-block px-3 py-2 rounded-xl max-w-[90%]'
    : 'bg-slate-900 text-slate-100 inline-block px-3 py-2 rounded-xl max-w-[90%]';
  const pre = document.createElement('pre');
  pre.className = 'whitespace-pre-wrap';
  pre.textContent = text;
  bubble.appendChild(pre);
  wrap.appendChild(bubble);
  chatBox.appendChild(wrap);
  chatBox.scrollTop = chatBox.scrollHeight;
}

if (chatForm && chatInput && chatBox) {
  chatForm.addEventListener('submit', async (e) => {
    e.preventDefault();
    const text = chatInput.value.trim();
    if (!text) return;
    appendBubble('user', text);
    chatInput.value = '';
    appendBubble('assistant', '··· pensando');
    try {
      const r = await fetch('/api/message', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ message: text })
      });
      const data = await r.json();
      chatBox.lastChild.remove(); // remove "pensando"
      if (!data.ok) throw new Error(data.error || 'Error');
      appendBubble('assistant', data.reply);
    } catch (err) {
      chatBox.lastChild.remove();
      appendBubble('assistant', '❌ ' + err.message);
    }
  });
}
